'<ADbasic Header, Headerversion 001.001>
' Process_Number                 = 1
' Initial_Processdelay           = 1000
' Eventsource                    = Timer
' Control_long_Delays_for_Stop   = No
' Priority                       = High
' Version                        = 1
' ADbasic_Version                = 6.2.0
' Optimize                       = Yes
' Optimize_Level                 = 1
' Stacksize                      = 1000
' Info_Last_Save                 = TUD205067  DASTUD\rgaudenzi
'<Header End>
'Calibration input-output voltage via electromigration module (S4C, log): 
'  Set output voltage ADwin (DATA_1 array) 
'  Via Iso-in to electromigration module (S4C, log)
'  Measure voltage of I-monitor (S4C, log) with V-measure module
'  Iso-out V-measure to analog input ADwin
'  Read ADC value and store in (DATA_2 array)

'Full range digits (0 to 65535) corresponds to -10V to 10V
'Voltage range -2V to 2V corresponds to digits range 26215:39321
'Par_1 and Par_2 minimum and maximum index calibration, set by Python code

DIM DATA_1[65536] as integer 'output voltage (digits)
DIM gain,i,sleep_time as integer

INIT:
  gain = 1
  sleep_time = Par_3   'in units of 100 ns 
  SET_MUX(0010000000b) 'gain 4
  SLEEP(1000)
  
EVENT:
  
  DAC(1, 0)
  SLEEP(10000000)  

  FOR i = 0 TO 65535
    
    If (i < Par_1) Then
      DATA_1[i] = 0 'fill output voltage array with 0V digits below voltage -2V
    Else
      If (i > Par_2) Then
        DATA_1[i] = 65535
      Else
        DAC(1, i)              'set output voltage
        SLEEP(sleep_time)      'sleep
        START_CONV(1)
        WAIT_EOC(1)
        DATA_1[i] = ReadADC(1) 'read input voltage and store in DATA_1 (digits)
      EndIf
    EndIf
    
  NEXT i
  
  DAC(1,32768)  'reset DAC1 to 0V
  END
